<?php
/*
 * login_with_pinterest.php
 *
 * @(#) $Id: login_with_pinterest.php,v 1.1 2017/03/17 09:08:30 mlemos Exp $
 *
 */

/*
 *  Get the http.php file from http://www.phpclasses.org/httpclient
 */
require('http.php');
require('oauth_client.php');

$client = new oauth_client_class();
$client->server = 'Pinterest';
$client->debug = true;
$client->debug_http = true;
$client->redirect_uri = 'http://'.$_SERVER['HTTP_HOST'].
    dirname(strtok($_SERVER['REQUEST_URI'], '?')).'/login_with_pinterest.php';

$client->client_id = '';
$application_line = __LINE__;
$client->client_secret = '';

if (strlen($client->client_id) == 0
|| strlen($client->client_secret) == 0) {
    die('Please go to Google APIs console page '.
        'https://developers.pinterest.com/apps/ in the API access tab, '.
        'create a new client ID, and in the line '.$application_line.
        ' set the client_id to Client ID and client_secret with Client Secret. '.
        'The callback URL must be '.$client->redirect_uri.' but make sure '.
        'the domain is valid and can be resolved by a public DNS.');
}

/* API permissions
 */
$client->scope = 'read_public';
if (($success = $client->Initialize())) {
    if (($success = $client->Process())) {
        if (strlen($client->authorization_error)) {
            $client->error = $client->authorization_error;
            $success = false;
        } elseif (strlen($client->access_token)) {
            $success = $client->CallAPI(
                'https://api.pinterest.com/v1/me/',
                'GET',
                array(),
                array('FailOnAccessError'=>true),
                $user
            );
        }
    }
    $success = $client->Finalize($success);
}
if ($client->exit) {
    exit;
}
if ($success) {
    ?>
<!DOCTYPE html>
<html>
<head>
<title>Pinterest OAuth client results</title>
</head>
<body>
<?php
            echo '<h1>', HtmlSpecialChars($user->data->first_name),
    ' you have logged in successfully with Google!</h1>';
    echo '<pre>', HtmlSpecialChars(print_r($user, 1)), '</pre>';
    ?>
</body>
</html>
<?php
} else {
    ?>
<!DOCTYPE html>
<html>
<head>
<title>OAuth client error</title>
</head>
<body>
<h1>OAuth client error</h1>
<pre>Error: <?php echo HtmlSpecialChars($client->error); ?></pre>
</body>
</html>
<?php
}

?>